<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class InsightsQuestionnairesQuestionOptions {
    /**
     * @param string $token The Token HTTP request header
     * @return CreateInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function create(string $token = Values::NONE): CreateInsightsQuestionnairesQuestionOptions {
        return new CreateInsightsQuestionnairesQuestionOptions($token);
    }

    /**
     * @param string $categoryId Category ID
     * @param string $token The Token HTTP request header
     * @return UpdateInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function update(string $categoryId = Values::NONE, string $token = Values::NONE): UpdateInsightsQuestionnairesQuestionOptions {
        return new UpdateInsightsQuestionnairesQuestionOptions($categoryId, $token);
    }

    /**
     * @param string $token The Token HTTP request header
     * @return DeleteInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function delete(string $token = Values::NONE): DeleteInsightsQuestionnairesQuestionOptions {
        return new DeleteInsightsQuestionnairesQuestionOptions($token);
    }
}

class CreateInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $token = Values::NONE) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.CreateInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}

class UpdateInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $categoryId Category ID
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $categoryId = Values::NONE, string $token = Values::NONE) {
        $this->options['categoryId'] = $categoryId;
        $this->options['token'] = $token;
    }

    /**
     * The ID of the category
     *
     * @param string $categoryId Category ID
     * @return $this Fluent Builder
     */
    public function setCategoryId(string $categoryId): self {
        $this->options['categoryId'] = $categoryId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.UpdateInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}

class DeleteInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $token = Values::NONE) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.DeleteInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}