<?php

declare (strict_types=1);
namespace Rector\Symfony\Utils\ValueObject;

final class ReturnTypeChange
{
    /**
     * @readonly
     * @var string
     */
    private $class;
    /**
     * @readonly
     * @var string
     */
    private $method;
    /**
     * @readonly
     * @var string
     */
    private $returnType;
    public function __construct(string $class, string $method, string $returnType)
    {
        $this->class = $class;
        $this->method = $method;
        $this->returnType = $returnType;
    }
    public function getClass() : string
    {
        return $this->class;
    }
    public function getMethod() : string
    {
        return $this->method;
    }
    public function getReturnType() : string
    {
        return $this->returnType;
    }
}
