<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Sheets;

class CandlestickSeries extends \Google\Model
{
  protected $dataType = ChartData::class;
  protected $dataDataType = '';
  public $data;

  /**
   * @param ChartData
   */
  public function setData(ChartData $data)
  {
    $this->data = $data;
  }
  /**
   * @return ChartData
   */
  public function getData()
  {
    return $this->data;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CandlestickSeries::class, 'Google_Service_Sheets_CandlestickSeries');
