<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudIntegrationsV1alphaResolveSuspensionRequest extends \Google\Model
{
  protected $suspensionType = GoogleCloudIntegrationsV1alphaSuspension::class;
  protected $suspensionDataType = '';
  public $suspension;

  /**
   * @param GoogleCloudIntegrationsV1alphaSuspension
   */
  public function setSuspension(GoogleCloudIntegrationsV1alphaSuspension $suspension)
  {
    $this->suspension = $suspension;
  }
  /**
   * @return GoogleCloudIntegrationsV1alphaSuspension
   */
  public function getSuspension()
  {
    return $this->suspension;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudIntegrationsV1alphaResolveSuspensionRequest::class, 'Google_Service_Integrations_GoogleCloudIntegrationsV1alphaResolveSuspensionRequest');
